/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.event;

import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.event.common.insulation.InsulationTickEvent;
import com.momosoftworks.coldsweat.api.insulation.AdaptiveInsulation;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.api.insulation.StaticInsulation;
import com.momosoftworks.coldsweat.api.temperature.modifier.ArmorInsulationTempModifier;
import com.momosoftworks.coldsweat.api.util.Placement;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.handler.ItemInsulationManager;
import com.momosoftworks.coldsweat.common.capability.insulation.IInsulatableCap;
import com.momosoftworks.coldsweat.common.capability.insulation.ItemInsulationCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.config.type.Insulator;
import com.momosoftworks.coldsweat.util.compat.CompatManager;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.math.FastMap;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ProcessEquipmentInsulation {
    @SubscribeEvent
    public static void applyArmorInsulation(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (event.phase == TickEvent.Phase.END && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player.f_19797_ % 20 == 0 && !player.f_19853_.f_46443_) {
                Advancement advancement;
                int fullyInsulatedSlots = 0;
                FastMap<String, Double> armorInsulation = new FastMap<String, Double>();
                double worldTemp = Temperature.get((LivingEntity)player, Temperature.Trait.WORLD);
                double minTemp = Temperature.get((LivingEntity)player, Temperature.Trait.FREEZING_POINT);
                double maxTemp = Temperature.get((LivingEntity)player, Temperature.Trait.BURNING_POINT);
                for (ItemStack armorStack : player.m_6168_()) {
                    if (!(armorStack.m_41720_() instanceof ArmorItem)) continue;
                    Collection armorInsulators = ConfigSettings.INSULATING_ARMORS.get().get((Object)armorStack.m_41720_());
                    if (!armorInsulators.isEmpty()) {
                        for (Insulator armorInsulator : armorInsulators) {
                            if (!armorInsulator.test((Entity)player, armorStack)) continue;
                            ProcessEquipmentInsulation.mapAdd(armorInsulation, "cold_armor", armorInsulator.insulation().getCold());
                            ProcessEquipmentInsulation.mapAdd(armorInsulation, "heat_armor", armorInsulator.insulation().getHeat());
                        }
                    } else {
                        Insulation value2;
                        LazyOptional<IInsulatableCap> iCap = ItemInsulationManager.getInsulationCap(armorStack);
                        List<Insulation> insulation = ItemInsulationManager.getAllEffectiveInsulation(armorStack, (LivingEntity)player);
                        for (Insulation value2 : insulation) {
                            if (value2 instanceof StaticInsulation) {
                                StaticInsulation insul = (StaticInsulation)value2;
                                ProcessEquipmentInsulation.mapAdd(armorInsulation, "cold_insulators", insul.getCold());
                                ProcessEquipmentInsulation.mapAdd(armorInsulation, "heat_insulators", insul.getHeat());
                                continue;
                            }
                            if (!(value2 instanceof AdaptiveInsulation)) continue;
                            AdaptiveInsulation insul = (AdaptiveInsulation)value2;
                            ProcessEquipmentInsulation.mapAdd(armorInsulation, "cold_insulators", CSMath.blend(insul.getInsulation() * 0.75, 0.0, insul.getFactor(), -1.0, 1.0));
                            ProcessEquipmentInsulation.mapAdd(armorInsulation, "heat_insulators", CSMath.blend(0.0, insul.getInsulation() * 0.75, insul.getFactor(), -1.0, 1.0));
                        }
                        if ((armorInsulation.getOrDefault("cold_insulators", 0.0) + armorInsulation.getOrDefault("heat_insulators", 0.0)) / 2.0 >= (double)ItemInsulationManager.getInsulationSlots(armorStack)) {
                            ++fullyInsulatedSlots;
                        }
                        if (iCap.resolve().isPresent() && (value2 = iCap.resolve().get()) instanceof ItemInsulationCap) {
                            ItemInsulationCap cap = (ItemInsulationCap)((Object)value2);
                            cap.calcAdaptiveInsulation(worldTemp, minTemp, maxTemp);
                            List<Pair<ItemStack, Multimap<Insulator, Insulation>>> totalInsulation = cap.getInsulation();
                            int filledInsulationSlots = (int)totalInsulation.stream().map(Pair::getSecond).flatMap(map -> map.values().stream()).map(Insulation::split).flatMap(Collection::stream).count();
                            if (filledInsulationSlots > ItemInsulationManager.getInsulationSlots(armorStack)) {
                                WorldHelper.playEntitySound(SoundEvents.f_12016_, (Entity)player, SoundSource.PLAYERS, 1.0f, 1.0f);
                            }
                            while (filledInsulationSlots > ItemInsulationManager.getInsulationSlots(armorStack)) {
                                ItemStack removedItem = cap.removeInsulationItem((ItemStack)totalInsulation.get(totalInsulation.size() - 1).getFirst());
                                ItemEntity droppedInsulation = new ItemEntity(player.f_19853_, player.m_20185_(), player.m_20186_() + (double)(player.m_20206_() / 2.0f), player.m_20189_(), removedItem);
                                droppedInsulation.m_32010_(8);
                                droppedInsulation.m_20256_(new Vec3(player.m_217043_().m_188583_() * 0.05, player.m_217043_().m_188583_() * 0.05 + 0.2, player.m_217043_().m_188583_() * 0.05));
                                player.f_19853_.m_7967_((Entity)droppedInsulation);
                                --filledInsulationSlots;
                            }
                        }
                    }
                    double armorAmount = armorStack.m_41638_(LivingEntity.m_147233_((ItemStack)armorStack)).entries().stream().filter(entry -> ((Attribute)entry.getKey()).equals(Attributes.f_22284_)).map(entry -> ((AttributeModifier)entry.getValue()).m_22218_()).mapToDouble(Double::doubleValue).sum();
                    ProcessEquipmentInsulation.mapAdd(armorInsulation, "cold_protection", Math.min(armorAmount, 20.0));
                    ProcessEquipmentInsulation.mapAdd(armorInsulation, "heat_protection", Math.min(armorAmount, 20.0));
                }
                for (ItemStack curio : CompatManager.getCurios((LivingEntity)player)) {
                    for (Insulator insulator : ConfigSettings.INSULATING_CURIOS.get().get((Object)curio.m_41720_())) {
                        if (!insulator.test((Entity)player, curio)) continue;
                        ProcessEquipmentInsulation.mapAdd(armorInsulation, "cold_curios", insulator.insulation().getCold());
                        ProcessEquipmentInsulation.mapAdd(armorInsulation, "heat_curios", insulator.insulation().getHeat());
                    }
                }
                InsulationTickEvent insulationEvent = new InsulationTickEvent(player, armorInsulation);
                MinecraftForge.EVENT_BUS.post((Event)insulationEvent);
                if (!insulationEvent.isCanceled()) {
                    double cold = insulationEvent.getProperty("cold");
                    double heat = insulationEvent.getProperty("heat");
                    Temperature.addOrReplaceModifier((LivingEntity)player, new ArmorInsulationTempModifier(cold, heat).tickRate(20).expires(20), Temperature.Trait.RATE, Placement.Duplicates.BY_CLASS);
                }
                if (fullyInsulatedSlots >= 4 && serverPlayer.m_20194_() != null && (advancement = serverPlayer.m_20194_().m_129889_().m_136041_(new ResourceLocation("cold_sweat:full_insulation"))) != null) {
                    serverPlayer.m_8960_().m_135988_(advancement, "requirement");
                }
            }
        }
    }

    private static void mapAdd(Map<String, Double> map, String key, double value) {
        map.put(key, map.getOrDefault(key, 0.0) + value);
    }

    @SubscribeEvent
    public static void onDamageTaken(LivingAttackEvent event) {
        DamageSource source = event.getSource();
        if (source == DamageSource.f_19309_ && event.getEntity().m_6844_(EquipmentSlot.FEET).m_150930_(ModItems.HOGLIN_HOOVES)) {
            event.setCanceled(true);
        }
    }
}

